#!/usr/bin/perl

use strict;
use warnings;

package SurePassID;

#!/usr/bin/perl
use strict;
use warnings;

 use LWP::UserAgent;
 use HTTP::Request;
 use JSON qw( decode_json );
 
 sub FormatTraceFileDate()
{
   my($sec,$min,$hour) = localtime();

    my $dtd = sprintf("%02d:%02d:%02d", $hour, $min, $sec);
 	return $dtd; 
} 
sub GetSurePassIdFolder()
{
    return "/etc/surepassid/rlm/"; 
	#return "F:/perl5/perl/rlm_surepassid/"; 
} 
sub EscapeJsonChars($) 
 {
    my $var = $_[0]; 
	
	$var =~ s'\\/'\\\\/'g;
	$var =~ s/\\"/\\\\"/g;
	
	$var =~ s/\\t/\\\\t/g;
	$var =~ s/\\r/\\\\r/g;
	$var =~ s/\\b/\\\\b/g;
	$var =~ s/\\f/\\\\f/g;
	$var =~ s/\\n/\\\\n/g;
		
	return $var; 
} 
sub FormatTraceFileName()
{
    my ($sec,$min,$hour,$mday,$mon,$year) = localtime();

	$mon = $mon +1;
	$year = $year + 1900;
        my $dtd = sprintf("%02d%02d%02d", $year, $mon, $mday);
	return GetSurePassIdFolder() . "SurePassRadiusServer$dtd.txt"; 
} 
sub WriteTrace($$)
{

    #print 'total elements = @-'; 
	
	my $filename = FormatTraceFileName(); 
	my $username = $_[0]; 
	my $data  = $_[1]; 
	
    my $dt = FormatTraceFileDate();
	
	if(length($username) == 0)
	{
	    $username = 'system'; 
	} 
	
	my $out  = "$dt|$username|$data\n";
        my $filename2 = ">>" . $filename; 
	
	open(FH, $filename2);

        print FH $out;
	
       close( FH );
 }  
sub WriteTraceOld($$$)
{

    #print 'total elements = @-'; 
	
	my $filename = $_[0]; 
	my $username = $_[1]; 
	my $data  = $_[2]; 
	
    my $dt = FormatTraceFileDate();
	my $out  = "$dt|$username|$data\n";
    my $filename2 = ">>" . $filename; 
	
    open(FH, $filename2);

    print FH $out;
	
    close( FH );
 }  
 sub CheckConfigParams(%)
 {
    my %params = @_;
	my @validParams = ('AuthServerURL','AuthServerToken','AuthServerKey');
	my $ret = 1; 
	my $index = 0; 

	for($index=0; $index<$#validParams; $index++)
	{
		if( exists($params{$validParams[$index]} ) ) {
		   
		} else {
			#WriteTrace($tracefile, $user, "CheckConfigParams() $validParams[0] is missing in config file"); 
			$ret = 0; 
		}
	} 
    return $ret;
   }
 
 sub ReadConfigParams($$)
 {
    my %params;
	my $data; 
    my $configfilename = "<" . GetSurePassIdFolder() . "$_[0]"; 
	my $line; 

	WriteTrace("system", "ReadConfigParams() - configfilename = $configfilename"); 

	open(FH, $configfilename);

 	
    #read each line 
	
	foreach $line (<FH>) {
	# remove the newline from $line.
        #chomp($line); 
        $line =~ s/\\|\R//g;

	   
	   if(length($line) == 0)
	   {
	       if ($_[1])
		   {
	          WriteTrace("system", "ReadConfigParams() - Blank line being ignored"); 
		   } 
	   } 
	   else 
	   {
		   if ($_[1])
		   {
			  WriteTrace("system", "ReadConfigParams() - Config file line=$line"); 
		   } 
			  

		   my ($key, $val) = split(/=/, $line,2);
			   
		   $params{$key} = $val; 
		} 
	   } 
	   	  
      close(FH);
      return %params;
   }
 sub AddSpJsonString($$$) 
 {
     my $ret = '  "' . $_[0] . '":"' . EscapeJsonChars($_[1]) . '"';
	 if ($_[2]) {
	   $ret=$ret . ",\n"; 
	   
	 } 
	 
	
 	 return $ret; 
 } 
 sub AddSpJsonHeader($$) 
 {
    my $ret = "\n" . AddSpJsonString("spAccountLoginName", EscapeJsonChars($_[0]),1); 
	$ret = $ret . AddSpJsonString("spAccountLoginKey", EscapeJsonChars($_[1]),1); 
	return $ret; 
 } 
 
 sub ValidateUser($$$$$$) 
 {
 
    my $serverEndPoint = $_[0]; 
	my $spLoginAccount = $_[1]; 
	my $spLoginKey     = $_[2]; 
	my $spUsername     = $_[3]; 
	my $pw             = $_[4]; 
	my $trace          = $_[5]; 
	my $sessionToken   = ""; 
	
    my $json = '{';
 
	$json = $json . AddSpJsonHeader($spLoginAccount, $spLoginKey); 
	$json = $json . AddSpJsonString("type", "validate_user", 1); 
	$json = $json . AddSpJsonString("username", $spUsername, 1); 
	$json = $json . AddSpJsonString("pw", $pw,0) . "\n"; 
	$json = $json . '}'; 

    if ($trace) {
	  WriteTrace($spUsername, "Sending $serverEndPoint:\n" . $json .  "\n");
    } 
 
	 my $ua = LWP::UserAgent->new(ssl_opts => { verify_hostname => 1 });
	 my $header = HTTP::Request->new(GET => $serverEndPoint);
	 my $request = HTTP::Request->new('POST', $serverEndPoint);
	 $request->header( 'Content-Type' => 'application/json' );
	 $request->content( $json );
	 my $response = $ua->request($request);
	 my $errorMsg = ""; 
	 my $errorCode = 0; 
  
     if ($response->is_success){

		 if ($trace) {
		     WriteTrace($spUsername, "Receiving:\n" . $response->content .  "\n");
		 }
	 
		 my $decoded = decode_json($response->content);
		 
		 $errorMsg = $decoded->{'errorMessage'}; 
	     $errorCode = $decoded->{'errorCode'};

                 if ($errorCode == 0)
                 {
	           $sessionToken = $decoded->{'sessionToken'}; 
                 }


   }elsif ($response->is_error){
       	 $errorMsg = $response->error_as_HTML; 
	     $errorCode = 9999; 
         if ($trace) {
		     WriteTrace($spUsername, "Error:\n" . $response->error_as_HTML . "\n");
		 }
    }
 
 
   return ($errorCode, $errorMsg, $sessionToken) 
 } 
 sub VerifyMethod($$$$$) 
 {
 
    my $serverEndPoint = $_[0]; 
	my $spLoginAccount = $_[1]; 
	my $spLoginKey     = $_[2]; 
	my $spUsername     = $_[3]; 
	my $trace          = $_[4]; 
	my @methods; 
	
    my $json = '{';
 
	$json = $json . AddSpJsonHeader($spLoginAccount, $spLoginKey); 
	$json = $json . AddSpJsonString("type", "get_verified_methods", 1); 
	$json = $json . AddSpJsonString("username", $spUsername, 0). "\n";  
	$json = $json . '}'; 
   

    if ($trace) {
	  WriteTrace($spUsername, "Sending $serverEndPoint:\n" . $json .  "\n");
    } 
 
	 my $ua = LWP::UserAgent->new(ssl_opts => { verify_hostname => 1 });
	 my $header = HTTP::Request->new(GET => $serverEndPoint);
	 my $request = HTTP::Request->new('POST', $serverEndPoint);
	 $request->header( 'Content-Type' => 'application/json' );
	 $request->content( $json );
	 my $response = $ua->request($request);
	 my $errorMsg = ""; 
	 my $errorCode = 0; 
  
     if ($response->is_success){

	    if ($trace) {
		WriteTrace($spUsername, "Receiving:\n" . $response->content .  "\n");
              } 

	 
		 my $decoded = decode_json($response->content);
		 
		 $errorMsg = $decoded->{'errorMessage'}; 
	     $errorCode = $decoded->{'errorCode'};
         @methods = $decoded->{'methods'};

   }elsif ($response->is_error){
       	 $errorMsg = $response->error_as_HTML; 
	     $errorCode = 9999; 

    }
 
   return ($errorCode, $errorMsg, @methods) 
 } 
 sub ValidateOtp($$$$$$$) 
 {
 
    my $serverEndPoint = $_[0]; 
	my $spLoginAccount = $_[1]; 
	my $spLoginKey     = $_[2]; 
	my $spUsername     = $_[3]; 
	my $psn            = $_[4]; 
	my $otp            = $_[5]; 
	my $trace          = $_[6]; 
	
    my $json = '{';
 
	$json = $json . AddSpJsonHeader($spLoginAccount, $spLoginKey); 
	$json = $json . AddSpJsonString("type", "validate_oath_otp", 1); 
	$json = $json . AddSpJsonString("username", $spUsername, 1); 
	$json = $json . AddSpJsonString("otp", $otp,1); 
	$json = $json . AddSpJsonString("psn", $psn,0); 
	$json = $json . '}'; 

    if ($trace) {
	  WriteTrace($spUsername, "Sending $serverEndPoint:\n" . $json .  "\n");
    } 
	 my $ua = LWP::UserAgent->new(ssl_opts => { verify_hostname => 1 });
	 my $header = HTTP::Request->new(GET => $serverEndPoint);
	 my $request = HTTP::Request->new('POST', $serverEndPoint);
	 $request->header( 'Content-Type' => 'application/json' );
	 $request->content( $json );
	 my $response = $ua->request($request);
	 my $errorMsg = ""; 
	 my $errorCode = 0; 
    
     if ($response->is_success){

		if ($trace) {
		     WriteTrace($spUsername, "Receiving:\n" . $response->content .  "\n");
		 }

	 
		 my $decoded = decode_json($response->content);
		 
		 $errorMsg = $decoded->{'errorMessage'}; 
	     $errorCode = $decoded->{'errorCode'}; 
	
   }elsif ($response->is_error){
       	 $errorMsg = $response->error_as_HTML; 
	     $errorCode = 9999; 

    }
 
   return ($errorCode, $errorMsg) 
 } 
 sub SendOtp($$$$$$$) 
 {
 
    my $serverEndPoint = $_[0]; 
	my $spLoginAccount = $_[1]; 
	my $spLoginKey     = $_[2]; 
	my $spUsername     = $_[3]; 
	my $delivery       = $_[4]; 
	my $alternateAddress = $_[5]; 
	my $trace          = $_[6]; 
	
    my $json = '{';
 
	$json = $json . AddSpJsonHeader($spLoginAccount, $spLoginKey); 
	$json = $json . AddSpJsonString("type", "send_oath_otp", 1); 
	$json = $json . AddSpJsonString("username", $spUsername, 1); 
	$json = $json . AddSpJsonString("deliveryMethod", $delivery,1); 
	$json = $json . AddSpJsonString("alternateAddress", $alternateAddress,0); 
	$json = $json . '}'; 

 	 my $ua = LWP::UserAgent->new(ssl_opts => { verify_hostname => 1 });
	 my $header = HTTP::Request->new(GET => $serverEndPoint);
	 my $request = HTTP::Request->new('POST', $serverEndPoint);
	 $request->header( 'Content-Type' => 'application/json' );
	 $request->content( $json );
	 my $response = $ua->request($request);
	 my $errorMsg = ""; 
         my $errorCode = 0; 
	    
         if ($response->is_success){

		 if ($trace) {
		     WriteTrace($spUsername, "Receiving:\n" . $response->content .  "\n");
		 }

	 
		 my $decoded = decode_json($response->content);
		 
		 $errorMsg = $decoded->{'errorMessage'}; 
	     $errorCode = $decoded->{'errorCode'}; 
		 

   }elsif ($response->is_error){
   		 $errorMsg = $response->error_as_HTML; 
	     $errorCode = 9999; 
    }
 
   return ($errorCode, $errorMsg) 
 } 
 sub SendPush($$$$$$$$$$) 
 {
 
    my $serverEndPoint = $_[0]; 
	my $spLoginAccount = $_[1]; 
	my $spLoginKey     = $_[2]; 
	my $spUsername     = $_[3]; 
	my $delivery       = $_[4]; 
        my $appName        = $_[5];
        my $authnReason    = $_[6];
        my $authnAccount   = $_[7];
        my $relyingPartyUrl = $_[8];
        my $trace          = $_[9]; 
	
        my $json = '{';
 
	$json = $json . AddSpJsonHeader($spLoginAccount, $spLoginKey); 
	$json = $json . AddSpJsonString("type", "send_push_message", 1); 
	$json = $json . AddSpJsonString("username", $spUsername, 1); 
	$json = $json . AddSpJsonString("deliveryMethod", $delivery,1); 
	$json = $json . AddSpJsonString("appName", $appName,1);
	$json = $json . AddSpJsonString("authnReason", $authnReason,1); 
	$json = $json . AddSpJsonString("authnAccount", $authnAccount,1); 
	$json = $json . AddSpJsonString("relyingPartyUrl", $relyingPartyUrl,0); 
	$json = $json . '}'; 

    if ($trace) {
	  WriteTrace($spUsername, "Sending $serverEndPoint:\n" . $json .  "\n");
    } 
 
	 my $ua = LWP::UserAgent->new(ssl_opts => { verify_hostname => 1 });
	 my $header = HTTP::Request->new(GET => $serverEndPoint);
	 my $request = HTTP::Request->new('POST', $serverEndPoint);
	 $request->header( 'Content-Type' => 'application/json' );
	 $request->content( $json );
	 my $response = $ua->request($request);
	 my $errorMsg = ""; 
	 my $errorCode = 0; 
	 my $authnReqId = ""; 
 
  
     if ($response->is_success){

		 if ($trace) {
		     WriteTrace($spUsername, "Receiving:\n" . $response->content .  "\n");
		 }

	 
		 my $decoded = decode_json($response->content);
		 
		 $errorMsg = $decoded->{'errorMessage'}; 
	     $errorCode = $decoded->{'errorCode'}; 
             if ($errorCode == 0)
                 {
	           $authnReqId = $decoded->{'authnUserReqId'}; 
                 }
			
   }elsif ($response->is_error){
     	 $errorMsg = $response->error_as_HTML; 
	     $errorCode = 9999; 

    }
 
   return ($errorCode, $errorMsg, $authnReqId) 
 } 
1;